% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/logL-methods.R
\name{logL}
\alias{logL}
\alias{logL,EL-method}
\alias{logL,ELT-method}
\alias{logL,SummaryEL-method}
\alias{logL,SummaryELT-method}
\alias{logL,SummaryLM-method}
\title{Empirical log-likelihood}
\usage{
\S4method{logL}{EL}(object, ...)

\S4method{logL}{ELT}(object, ...)

\S4method{logL}{SummaryEL}(object, ...)

\S4method{logL}{SummaryELT}(object, ...)

\S4method{logL}{SummaryLM}(object, ...)
}
\arguments{
\item{object}{An object that contains the empirical log-likelihood.}

\item{...}{Further arguments passed to methods.}
}
\value{
A single numeric.
}
\description{
Extracts the empirical log-likelihood from a model.
}
\examples{
data("precip")
fit <- el_mean(precip, par = 40)
logL(fit)
}
\references{
Baggerly KA (1998).
``Empirical Likelihood as a Goodness-of-Fit Measure.''
\emph{Biometrika}, \strong{85}(3), 535--547.
\doi{10.1093/biomet/85.3.535}.
}
\seealso{
\linkS4class{EL}, \linkS4class{ELT}
}
