% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_control.R
\name{el_control}
\alias{el_control}
\title{Control parameters for computation}
\usage{
el_control(
  maxit = 200L,
  maxit_l = 25L,
  tol = 1e-06,
  tol_l = 1e-06,
  step = NULL,
  th = NULL,
  verbose = FALSE,
  keep_data = TRUE,
  nthreads,
  seed = NULL,
  b = 10000L,
  m = 1000000L
)
}
\arguments{
\item{maxit}{A single integer for the maximum number of iterations for
constrained minimization of empirical likelihood. Defaults to \code{200}.}

\item{maxit_l}{A single integer for the maximum number of iterations for
evaluation of empirical likelihood. Defaults to \code{25}.}

\item{tol}{A single numeric for the convergence tolerance for the constrained
minimization. Defaults to \code{1e-06}.}

\item{tol_l}{A single numeric for the relative convergence tolerance for the
evaluation. Defaults to \code{1e-06}.}

\item{step}{A single numeric for the step size for projected gradient descent
method. Defaults to \code{NULL} and sets the step size to the reciprocal of the
sample size.}

\item{th}{A single numeric for the threshold for the negative empirical
log-likelihood ratio. The iteration stops if the value exceeds the
threshold. Defaults to \code{NULL} and sets the threshold to \code{200 * d}, where
\code{d} corresponds to the degrees of freedom of the limiting chi-squared
distribution of the statistic.}

\item{verbose}{A single logical. If \code{TRUE}, a message on the convergence
status is printed when fitting objects that inherit from class
\linkS4class{EL}.
Defaults to \code{FALSE}.}

\item{keep_data}{A single logical. If \code{TRUE}, the data used for fitting
objects that inherit from class \linkS4class{EL} are stored for later use
with other methods. Defaults to \code{TRUE}.}

\item{nthreads}{A single integer for the number of threads for parallel
computation via OpenMP (if available). Defaults to half the available
threads. For better performance, it is generally recommended in most
platforms to limit the number of threads to the number of physical cores.
Note that it applies to the following functions that involve multiple
evaluations or optimizations: \code{\link[=confint]{confint()}}, \code{\link[=confreg]{confreg()}}, \code{\link[=el_lm]{el_lm()}},
\code{\link[=el_glm]{el_glm()}}, \code{\link[=eld]{eld()}}, and \code{\link[=elt]{elt()}}.}

\item{seed}{A single integer for the seed for random number generation. It
only applies to \code{\link[=elt]{elt()}} when \code{calibrate} is set to \code{"boot"}. Defaults to
\code{NULL}. In this case, a seed is set to a random integer generated from 1 to
the maximum integer supported by \R on the machine, which is determined by
\code{\link[=set.seed]{set.seed()}}. Only one seed is needed even when multiple threads are used
with \code{nthreads}. Each thread is given a separate seed to produce a
non-overlapping but reproducible sequence of random numbers. The
Xoshiro256+ pseudo-random number generator is used internally to work with
OpenMP.}

\item{b}{A single integer for the number of bootstrap replicates. It only
applies to \code{\link[=elt]{elt()}} when \code{calibrate} is set to \code{"boot"}. Defaults to
\code{10000}.}

\item{m}{A single integer for the number of Monte Carlo samples. It only
applies to \code{\link[=elmt]{elmt()}}. Defaults to \code{1e+06}.}
}
\value{
An object of class of \linkS4class{ControlEL}.
}
\description{
Specifies computational details of (constrained) empirical likelihood.
}
\examples{
optcfg <- el_control(maxit = 300, step = 0.01, th = 200, nthreads = 1)
}
\seealso{
\code{\link[=el_eval]{el_eval()}}, \code{\link[=elt]{elt()}}
}
