% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMandala.R
\name{PlotMandala}
\alias{PlotMandala}
\title{Plot Mandala}
\usage{
PlotMandala(
  radius = c(1.1, 1.8),
  npoints = 14L,
  depth = 3L,
  scheme = NULL,
  mar = c(0, 0, 0, 0),
  seed = NULL
)
}
\arguments{
\item{radius}{'numeric' vector of length 1 or 2.
Factor of expansion or compression.
A random-number generator may be used by defining the
lower and upper limits of a uniform distribution.}

\item{npoints}{'integer' vector.
Number of points is randomly selected from this argument.}

\item{depth}{'integer' vector.
Number of iterations is randomly selected from this argument.}

\item{scheme}{'character' vector.
Name of color palette(s) to choose from, see
\code{\link[wesanderson:wes_palette]{wes_palette}} function for choices.
By default, specified using a random selection from all possible palettes.}

\item{mar}{'numeric' vector of length 4.
Number of lines of margin to be specified on the bottom, left, top, and right side of the plot.}

\item{seed}{'integer' count.
Random number generator state, used to replicate the mandala.}
}
\value{
Invisible \code{NULL}
}
\description{
Draw a colored mandala using Voronoi tessellation and a Wes Anderson color palette.
}
\details{
\if{html}{\figure{mandala.svg}{options: width=480px}}
  \if{latex}{\figure{mandala.pdf}{options: width=4in}}
}
\examples{
meditate::PlotMandala()

\dontrun{
for (seed in sample.int(1e8, 100)) {
  cat("seed =", seed, "\n")
  meditate::PlotMandala(seed = seed)
  ans <- if (interactive()) readline("continue? [Y/n]: ") else "n"
  if (tolower(substr(ans, 1, 1)) == "n") break
}

svglite::svglite("mandala.svg", width = 7, height = 7, bg = "transparent")
meditate::PlotMandala(seed = 8471)
grDevices::dev.off()

grDevices::pdf("mandala.pdf")
meditate::PlotMandala(seed = 8471)
grDevices::dev.off()
}

}
\references{
This function was derived from the
  \href{https://github.com/aschinchon/mandalas-colored}{mandalas-colored}
  \R script by A.S. Chinchón, accessed on Dec 13, 2019.
}
\author{
J.C. Fisher
}
\keyword{hplot}
