% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate-rsi.R
\name{icd9cm_sessler_rsi}
\alias{icd9cm_sessler_rsi}
\title{Returns composite Sessler risk stratification index, given a list of ICD-9-CM codes.}
\usage{
icd9cm_sessler_rsi(icd9)
}
\arguments{
\item{icd9}{a unique character vector of ICD-9-CM codes}
}
\value{
The risk stratification index score
}
\description{
ICD-9-CM codes must have periods removed.  Diagnostic codes are prefixed with
'D' while procedure codes are prefixed with 'P'. So, diagnostic code
\code{404.03} should be \code{"D40403"}.
}
\details{
Note: A subsequent publication (Sigakis, 2013) found the following:
"Calibration "in-the-large" for RSI in-hospitalmortality illustrated a discrepancy
between actual (1.5%) and predicted (51.7%) in-hospital mortality. The authors
identified a regression constant (-2.198) in the published RSI
"all-covariates.xls" file that was not used in the published SPSS implementation
macro."
}
\examples{
# Calculate RSI for each patient ("id") in dataframe
cases <- data.frame(id=c(1,1,1,2,2,2),
  icd9cm=c("D20206","D24220","D4439","D5064","DE8788","D40403"),
  stringsAsFactors=TRUE)
library(plyr)
ddply(cases, .(id), function(x) { icd9cm_sessler_rsi(x$icd9cm) } )
}
\references{
1. Sessler DI, Sigl JC, Manberg PJ, Kelley SD, Schubert A, Chamoun NG.
    Broadly applicable risk stratification system for predicting duration of hospitalization and mortality.
    Anesthesiology. 2010 Nov;113(5):1026-37. doi: 10.1097/ALN.0b013e3181f79a8d.

2. Sigakis MJG, Bittner EA, Wanderer JP: Validation of a risk stratification
    index and risk quantification index for predicting patient outcomes:
    in-hospital mortality, 30-day mortality, 1-year mortality, and length-of-stay.
    Anesthesiology 2013; 119:525-40
}
\author{
Tom Joseph <thomas.joseph@mountsinai.org>,
Patrick McCormick <patrick.mccormick@mountsinai.org>
}
