% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd9cm.R
\name{melt_icd9list}
\alias{melt_icd9list}
\title{Convert ICD-9-CM code list to dataframe}
\usage{
melt_icd9list(df, idvar = "id", icd9var = "icd9cm", .progress = "none",
  .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{df}{a data frame with at least two columns, specified as \code{idvar}
and \code{icd9var}.}

\item{idvar}{string with name of ID variable within \code{df} (defaults to "id")}

\item{icd9var}{string with name of ICD code variable within \code{df} (defaults to "icd9cm")}

\item{.progress}{passed to \code{\link{ddply}}}

\item{.parallel}{passed to \code{\link{ddply}}}

\item{.paropts}{passed to \code{\link{ddply}}}
}
\value{
a dataframe with two columns, \code{idvar} and \code{"icd9cm"}
}
\description{
\code{melt_icd9list} uses \code{\link{ddply}} to melt a column of comma-separated ICD-9-CM
codes into a series of rows, one for each code.
}
\examples{
cases <- data.frame(id=c(1,2), icd9list=c('162.4,070.30,155.0,401.9','996.52,E878.8,V45.86'))
melt_icd9list(cases, "id", "icd9list")
}

