% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediationsens.R
\name{sens.plot}
\alias{sens.plot}
\title{Simulation-Based Sensitivity Analysis Plot for Causal Mediation Analysis}
\usage{
sens.plot(sens.results, effect = "NIE", est)
}
\arguments{
\item{sens.results}{An output from the sens function.}

\item{effect}{The name of the effect whose sensitivity analysis results are to be plotted (string). "NIE" for natural indirect effect. "NDE" for natural direct effect. The default is "NIE".}

\item{est}{The method used in the estimation of the causal mediation effects. "rmpw" uses the weighting-based method. "regression" uses the regression-based method developed by VanderWeele and Vansteelandt (2009). "simulation" uses the simulation-based method developed by Imai et al. (2010a, 2010b).}
}
\value{
Sensitivity analysis plots for the natural direct and in direct effects.
}
\description{
This function is used to visually represent the sensitivity analysis results when the treatment is randomized. Each black contour represents the combinations of sensitivity parameters that lead to the same indirect effect estimate as indicated by the number on the contour. The sensitivity parameters along the red dashed curves reduce the estimate to zero. In the region between the two blue dotted curves that bracket the red curve, the effect is changed to be insignificant at the significance level of 0.05. The larger the magnitudes of the sensitivity parameters are for removing the effects or changing their significance, the less sensitive the results are. Each dot corresponds to the conditional associations of each observed covariate with the outcome and the mediator, which are used to calibrate the strength of the sensitivity parameters.
}
\references{
Qin, X., & Yang, F. (2020). Simulation-Based Sensitivity Analysis for Causal Mediation Studies.
}
\author{
Xu Qin and Fan Yang
}
