% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_binaryclass.R
\name{NPV}
\alias{NPV}
\title{Negative predictive value}
\usage{
NPV(truth, response, negative)
}
\arguments{
\item{truth}{vector of true values}

\item{response}{vector of predicted values}

\item{negative}{negative class}
}
\description{
Defined as: tn / (tn + fn).
}
\examples{
n = 20
set.seed(125)
truth = as.factor(sample(c(1,0), n, replace = TRUE))
probabilities = runif(n)
response = as.factor(as.numeric(probabilities > 0.5))
negative = 0
NPV(truth, response, negative)
}
