% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_binaryclass.R
\name{PPV}
\alias{PPV}
\title{Positive predictive value}
\usage{
PPV(truth, response, positive, probabilities = NULL)
}
\arguments{
\item{truth}{vector of true values}

\item{response}{vector of predicted values}

\item{positive}{positive class}

\item{probabilities}{[numeric] vector of predicted probabilities}
}
\description{
Defined as: tp / (tp + fp). Also called precision. If the denominator is 0, PPV is set to be either 1 or 0 
depending on whether the highest probability prediction is positive (1) or negative (0).
}
\examples{
n = 20
set.seed(125)
truth = as.factor(sample(c(1,0), n, replace = TRUE))
probabilities = runif(n)
response = as.factor(as.numeric(probabilities > 0.5))
positive = 1
PPV(truth, response, positive, probabilities = NULL)
}
