/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms.scrollabledesktop;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JInternalFrame;
import multidendrograms.forms.scrollabledesktop.BaseInternalFrame;
import multidendrograms.forms.scrollabledesktop.DesktopConstants;
import multidendrograms.forms.scrollabledesktop.DesktopScrollPane;

public class FramePositioning
implements DesktopConstants {
    private DesktopScrollPane desktopScrollpane;
    private boolean autoTile;

    public FramePositioning(DesktopScrollPane desktopScrollPane) {
        this.desktopScrollpane = desktopScrollPane;
    }

    public void setAutoTile(boolean bl) {
        this.autoTile = bl;
        if (bl) {
            this.tileInternalFrames();
        } else {
            this.cascadeInternalFrames();
        }
    }

    public boolean getAutoTile() {
        return this.autoTile;
    }

    public void cascadeInternalFrames() {
        JInternalFrame[] jInternalFrameArray = this.desktopScrollpane.getAllFrames();
        int n = 0;
        for (int i = jInternalFrameArray.length - 1; i >= 0; --i) {
            BaseInternalFrame baseInternalFrame = (BaseInternalFrame)jInternalFrameArray[i];
            if (baseInternalFrame.isIcon()) continue;
            baseInternalFrame.setSize(baseInternalFrame.getInitialDimensions());
            baseInternalFrame.setLocation(this.cascadeInternalFrame(baseInternalFrame, n++));
        }
    }

    public Point cascadeInternalFrame(JInternalFrame jInternalFrame) {
        return this.cascadeInternalFrame(jInternalFrame, this.desktopScrollpane.getNumberOfFrames());
    }

    private Point cascadeInternalFrame(JInternalFrame jInternalFrame, int n) {
        int n2;
        int n3 = jInternalFrame.getWidth();
        int n4 = jInternalFrame.getHeight();
        Rectangle rectangle = this.desktopScrollpane.getViewport().getViewRect();
        int n5 = (rectangle.width - n3) / 30;
        if (n5 < 1) {
            n5 = 1;
        }
        if ((n2 = (rectangle.height - n4) / 30) < 1) {
            n2 = 1;
        }
        int n6 = rectangle.x + 30 * (n + 1 - (n5 - 1) * (n / n5));
        int n7 = rectangle.y + 30 * (n + 1 - n2 * (n / n2));
        return new Point(n6, n7);
    }

    public void tileInternalFrames() {
        int n;
        Rectangle rectangle = this.desktopScrollpane.getViewport().getViewRect();
        int n2 = 0;
        JInternalFrame[] jInternalFrameArray = this.desktopScrollpane.getAllFrames();
        for (n = 0; n < jInternalFrameArray.length; ++n) {
            if (jInternalFrameArray[n].isIcon()) continue;
            ++n2;
        }
        n = 0;
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0) {
            int n5 = (int)Math.sqrt(n2);
            int n6 = rectangle.width / n5;
            for (n = 0; n < n5; ++n) {
                int n7 = n2 / n5;
                int n8 = n2 % n5;
                if (n5 - n <= n8) {
                    ++n7;
                }
                int n9 = rectangle.height / n7;
                for (n3 = 0; n3 < n7; ++n3) {
                    while (jInternalFrameArray[n4].isIcon()) {
                        ++n4;
                    }
                    jInternalFrameArray[n4].setBounds(n * n6, n3 * n9, n6, n9);
                    ++n4;
                }
            }
        }
    }
}

