% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-mbd.R
\name{export_mdb}
\alias{export_mdb}
\title{Save a table as a text file}
\usage{
export_mdb(
  file,
  table = NULL,
  path = "",
  delim = ",",
  quote = "\\"",
  quote_escape = "\\"",
  col_names = TRUE,
  date_format = "\%Y-\%m-\%d \%H:\%M:\%S"
)
}
\arguments{
\item{file}{Path to the Microsoft Access file.}

\item{table}{Name of the table, use \code{mdb_tables()}.}

\item{path}{Path or connection to write to. Empty string prints to console.}

\item{delim}{Single character used to separate fields within a record.}

\item{quote}{Single character used to quote strings. Defaults to \verb{"}.}

\item{quote_escape}{A single character (or empty string) to escape double
quotes with text columns. Defaults to doubling although backslashes are
also used.}

\item{col_names}{Whether or not to suppress column names from the table.}

\item{date_format}{The format in which date columns are converted. MDB Tools
uses the \code{strftime(3)} format, similar to \code{\link[readr:parse_datetime]{readr::parse_date()}}. No need to
specify whole string. Defaults to ISO8601.}
}
\value{
Invisibly, the path of the new file written.
}
\description{
Write a Microsoft Access table directly to a text file.
}
\examples{
\dontrun{
export_mdb(mdb_example(), "Airlines", path = TRUE)
}
}
