% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcrpure.R
\name{plotPuritySpectra.mcrpure}
\alias{plotPuritySpectra.mcrpure}
\title{Purity spectra plot}
\usage{
\method{plotPuritySpectra}{mcrpure}(
  obj,
  comp = seq_len(obj$ncomp),
  type = "l",
  col = mdaplot.getColors(obj$ncomp),
  show.lines = TRUE,
  lines.col = adjustcolor(col, alpha.f = 0.75),
  lines.lty = 3,
  lines.lwd = 1,
  ...
)
}
\arguments{
\item{obj}{\code{mcrpure} object}

\item{comp}{vector of components to show the purity spectra for}

\item{type}{type of the plot}

\item{col}{colors for the plot (should be a vector with one value for each component in \code{obj})}

\item{show.lines}{if \code{TRUE} show the selected pure variables as vertical lines}

\item{lines.col}{color for the selected pure variable lines (by default same as for plots but semitransparent)}

\item{lines.lty}{line type for the purity lines}

\item{lines.lwd}{line width for the purity lines}

\item{...}{other parameters suitable for \code{mdaplotg}

The plot shows weighted purity value of each variable separately for each specified component.}
}
\description{
Purity spectra plot
}
