% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regcoeffs.R
\name{plot.regcoeffs}
\alias{plot.regcoeffs}
\title{Regression coefficients plot}
\usage{
\method{plot}{regcoeffs}(
  x,
  ncomp = 1,
  ny = 1,
  type = (if (x$nvar > 30) "l" else "h"),
  col = c(mdaplot.getColors(1), "lightgray"),
  show.lines = c(NA, 0),
  show.ci = FALSE,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{x}{regression coefficients object (class \code{regcoeffs})}

\item{ncomp}{number of components to use for creating the plot}

\item{ny}{index of response variable to make the plot for}

\item{type}{type of the plot}

\item{col}{vector with two colors for the plot (one is used to show real coefficient and another one to
show confidence intervals)}

\item{show.lines}{allows to show horizontal line at c(NA, 0)}

\item{show.ci}{logical, show or not confidence intervals if they are available}

\item{alpha}{significance level for confidence intervals (a number between 0 and 1, e.g.
for 95\% alpha = 0.05)}

\item{...}{other arguments for plotting methods (e.g. main, xlab, etc)}
}
\description{
Shows plot with regression coefficient values for every predictor variable (x)
}
