% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdaplotg.R
\name{mdaplotg}
\alias{mdaplotg}
\title{Plotting function for several plot series}
\usage{
mdaplotg(
  data,
  groupby = NULL,
  type = "p",
  pch = 16,
  lty = 1,
  lwd = 1,
  cex = 1,
  col = NULL,
  bwd = 0.8,
  legend = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  labels = NULL,
  ylim = NULL,
  xlim = NULL,
  colmap = "default",
  legend.position = "topright",
  show.legend = TRUE,
  show.labels = FALSE,
  show.lines = FALSE,
  show.grid = TRUE,
  grid.lwd = 0.5,
  grid.col = "lightgray",
  xticks = NULL,
  xticklabels = NULL,
  yticks = NULL,
  yticklabels = NULL,
  show.excluded = FALSE,
  lab.col = "darkgray",
  lab.cex = 0.65,
  xlas = 1,
  ylas = 1,
  opacity = 1,
  ...
)
}
\arguments{
\item{data}{a matrix, data frame or a list with data values (see details below).}

\item{groupby}{one or several factors used to create groups of data matrix rows (works if data is a matrix)}

\item{type}{type of the plot ('p', 'l', 'b', 'h', 'e').}

\item{pch}{a character for markers (same as \code{plot} parameter).}

\item{lty}{the line type (same as \code{plot} parameter).}

\item{lwd}{the line width (thickness) (same as \code{plot} parameter).}

\item{cex}{the cex factor for the markers (same as \code{plot} parameter).}

\item{col}{colors for the plot series}

\item{bwd}{a width of a bar as a percent of a maximum space available for each bar.}

\item{legend}{a vector with legend elements (if NULL, no legend will be shown).}

\item{xlab}{a title for the x axis (same as \code{plot} parameter).}

\item{ylab}{a title for the y axis (same as \code{plot} parameter).}

\item{main}{an overall title for the plot (same as \code{plot} parameter).}

\item{labels}{what to use as labels ('names' - row names, 'indices' - row indices, 'values' - values).}

\item{ylim}{limits for the y axis (if NULL, will be calculated automatically).}

\item{xlim}{limits for the x axis (if NULL, will be calculated automatically).}

\item{colmap}{a colormap to generate colors if \code{col} is not provided}

\item{legend.position}{position of the legend ('topleft', 'topright', 'top', 'bottomleft', 'bottomright', 'bottom').}

\item{show.legend}{logical, show or not legend for the data objects.}

\item{show.labels}{logical, show or not labels for the data objects.}

\item{show.lines}{vector with two coordinates (x, y) to show horizontal and vertical line cross the point.}

\item{show.grid}{logical, show or not a grid for the plot.}

\item{grid.lwd}{line thinckness (width) for the grid}

\item{grid.col}{line color for the grid}

\item{xticks}{tick values for x axis.}

\item{xticklabels}{labels for x ticks.}

\item{yticks}{tick values for y axis.}

\item{yticklabels}{labels for y ticks.}

\item{show.excluded}{logical, show or hide rows marked as excluded (attribute `exclrows`)}

\item{lab.col}{color for data point labels.}

\item{lab.cex}{size for data point labels.}

\item{xlas}{orientation of xticklabels}

\item{ylas}{orientation of yticklabels}

\item{opacity}{opacity for plot colors (value between 0 and 1)}

\item{...}{other plotting arguments.}
}
\description{
\code{mdaplotg} is used to make different kinds of plots or their combination for several sets
of objects.
}
\details{
The \code{mdaplotg} function is used to make a plot with several sets of objects. Simply
speaking, use it when you need a plot with legend. For example to show line plot with spectra
from calibration and test set, scatter plot with height and weight values for women and men, and
so on.

Most of the parameters are similar to \code{\link{mdaplot}}, the difference is described below.

The data should be organized as a list, every item is a matrix (or data frame) with data for one
set of objects. Alternatively you can provide data as a matrix and use parameter
\code{groupby} to create the groups. See tutorial for more details.

There is no color grouping option, because color is used to separate the sets. Marker symbol,
line style and type, etc. can be defined as a single value (one for all sets) and as a vector
with one value for each set.
}
\author{
Sergey Kucheryavskiy (svkucheryavski@gmail.com)
}
