% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef}
\alias{coef}
\alias{coef.mcmc}
\title{Term coefficients}
\usage{
\method{coef}{mcmc}(object, conf_level = 0.95, estimate = median, simplify = FALSE, ...)
}
\arguments{
\item{object}{The MCMC object to get the coefficients for}

\item{conf_level}{A number specifying the confidence level. By default 0.95.}

\item{estimate}{The function to use to calculate the estimate.}

\item{simplify}{A flag specifying whether to return just the estimate, lower, upper and svalue.}

\item{...}{Unused.}
}
\value{
An data frame of the coefficients with the columns indicating the
\code{term}, \code{estimate}, the standard deviation (\code{sd}) and \code{zscore} (if \code{simplify = FALSE}),
\code{lower} and \code{upper} credible intervals and \code{pvalue} or \code{svalue} (if \code{simplify = TRUE}).
}
\description{
Gets coefficients for all the terms in an MCMC object.
}
\section{Methods (by class)}{
\itemize{
\item \code{mcmc}: Get coefficients for terms in mcmc object
}}

\examples{
coef(mcmcr_example)
}
\seealso{
\link[stats:coef]{stats::coef}
}
