% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as.mcmcarray}
\alias{as.mcmcarray}
\alias{as.mcmcarray.default}
\alias{as.mcmcarray.mcarray}
\alias{as.mcmcarray.mcmc}
\alias{as.mcmcarray.mcmc.list}
\alias{as.mcmcarray.mcmcr}
\title{Coerce to an mcmcarray object}
\usage{
as.mcmcarray(x, ...)

\method{as.mcmcarray}{default}(x, ...)

\method{as.mcmcarray}{mcarray}(x, ...)

\method{as.mcmcarray}{mcmc}(x, ...)

\method{as.mcmcarray}{mcmc.list}(x, ...)

\method{as.mcmcarray}{mcmcr}(x, ...)
}
\arguments{
\item{x}{object to coerce.}

\item{...}{Unused.}
}
\description{
Coerces MCMC objects to an \code{\link{mcmcarray-object}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Coerces vector, matrix or array to an mcmcarray object

\item \code{mcarray}: Coerces mcarray object to an mcmcarray object

\item \code{mcmc}: Coerces mcmc object (with one parameter) to an mcmcarray object

\item \code{mcmc.list}: Coerces mcmc.list object (with one parameter) to an mcmcarray object

\item \code{mcmcr}: Coerces mcmcr object (with one parameter) to an mcmcarray object
}}

\examples{
as.mcmcarray(as.mcarray(mcmcr_example$beta))
}
