% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lagr.R
\name{add_lagr.mcgf}
\alias{add_lagr.mcgf}
\alias{lagr<-}
\title{Add lagr model outputted from \code{\link[=fit_lagr]{fit_lagr()}} to a \code{mcgf} object.}
\usage{
\method{add_lagr}{mcgf}(x, fit_lagr, ...)

lagr(x) <- value
}
\arguments{
\item{x}{An \code{mcgf} object.}

\item{fit_lagr}{Output from the \code{\link[=fit_lagr]{fit_lagr()}} function.}

\item{...}{Additional arguments. Not in use.}

\item{value}{A list containing the lagr model as well as its parameters. It
must contains \code{model}, \code{par_lagr}, and \code{cor_lagr}.}
}
\value{
\code{x} with newly added attributes of the Lagrangian model.
}
\description{
Add lagr model outputted from \code{\link[=fit_lagr]{fit_lagr()}} to a \code{mcgf} object.
}
\examples{
data(sim1)
sim1_mcgf <- mcgf(sim1$data, dists = sim1$dists)
sim1_mcgf <- add_acfs(sim1_mcgf, lag_max = 5)
sim1_mcgf <- add_ccfs(sim1_mcgf, lag_max = 5)

# Fit a separable model and store it to 'sim1_mcgf'
fit_sep <- fit_base(
    sim1_mcgf,
    model = "sep",
    lag = 5,
    par_init = c(
        c = 0.001,
        gamma = 0.5,
        a = 0.3,
        alpha = 0.5
    ),
    par_fixed = c(nugget = 0)
)
sim1_mcgf <- add_base(sim1_mcgf, fit_base = fit_sep)

# Fit a Lagrangian model
fit_lagr <- fit_lagr(
    sim1_mcgf,
    model = "lagr_tri",
    par_init = c(v1 = 300, v2 = 300, lambda = 0.15),
    par_fixed = c(k = 2)
)

# Store the fitted Lagrangian model to 'sim1_mcgf'
sim1_mcgf <- add_lagr(sim1_mcgf, fit_lagr = fit_lagr)
model(sim1_mcgf, old = TRUE)
}
\seealso{
Other functions on fitting an mcgf: 
\code{\link{add_base.mcgf}()},
\code{\link{fit_base.mcgf}()},
\code{\link{fit_lagr.mcgf}()},
\code{\link{krige.mcgf}()}
}
\concept{functions on fitting an mcgf}
