% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtornado.R
\name{ggtornado}
\alias{ggtornado}
\alias{ggtornadounc}
\title{Draws a Tornado chart as provided by tornado (ggplot version).}
\usage{
## For class 'tornado'
ggtornado(x, 
  which=1, 
  name=NULL, 
  stat=c("median","mean"), 
  xlab="method", 
  ylab=""
)

## For class 'tornadounc'
ggtornadounc(x,
  which=1, 
  stat="median", 
  name=NULL, 
  xlab="method", 
  ylab=""
)

ggtornadounc(
  x,
  which = 1,
  stat = "median",
  name = NULL,
  xlab = "method",
  ylab = ""
)
}
\arguments{
\item{x}{A tornado object as provided by the \code{\link{tornado}} function.}

\item{which}{Which output to print -for multivariates output-.}

\item{name}{Vector of name of input variables. If NULL, the name will be given from the name of the elements.}

\item{stat}{The name of the statistics of the output to be considered. For a tornado object: "median" or "mean". For a tornadounc object: the value should match one row name of the tornadounc object. Alternatively, for a tornadounc object, the number of the row may be used.}

\item{xlab}{Label of the x axis. Default is to use the correlation method used in the tornado object.}

\item{ylab}{Label of the y axis. Default is empty.}
}
\description{
Draws a Tornado chart as provided by tornado.
}
\examples{
data(ec)
x <- evalmcmod(ec$modEC2, nsv=100, nsu=100, seed=666)
tor <- tornado(x, 7)
ggtornado(tor)
data(total)
ggtornado(tornadounc(total, 10, use="complete.obs"), which=1)
}
\seealso{
\code{\link{tornado}}
}
