% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rowcolval_to_mat}
\alias{rowcolval_to_mat}
\title{Collapse a tidy data frame into a matrix with named rows and columns}
\usage{
rowcolval_to_mat(
  .DF,
  matvals = "matvals",
  rownames = "rownames",
  colnames = "colnames",
  rowtypes = "rowtypes",
  coltypes = "coltypes",
  fill = 0,
  matrix.class = lifecycle::deprecated(),
  matrix_class = c("matrix", "Matrix")
)
}
\arguments{
\item{.DF}{A tidy data frame containing columns for row names, column names, and values.}

\item{matvals}{The name of the column in \code{.DF} containing values with which to fill the matrix (a string). Default is "matvals".}

\item{rownames}{The name of the column in \code{.DF} containing row names (a string). Default is "rownames".}

\item{colnames}{The name of the column in \code{.DF} containing column names (a string). Default is "colnames".}

\item{rowtypes}{An optional string identifying the types of information found in rows of the matrix to be constructed. Default is "rowtypes".}

\item{coltypes}{An optional string identifying the types of information found in columns of the matrix to be constructed. Default is "coltypes".}

\item{fill}{The value for missing entries in the resulting matrix. default is \code{0}.}

\item{matrix.class}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{matrix_class} instead.}

\item{matrix_class}{One of "matrix" or "Matrix".
"matrix" creates a \code{base::matrix} object with the \code{matrix()} function.
"Matrix" creates a \code{Matrix::Matrix} object using the \code{matsbyname::Matrix()} function.
This could be a sparse matrix.
Default is "matrix".}
}
\value{
A matrix with named rows and columns and, optionally, row and column types.
}
\description{
Columns not specified in one of \code{rownames}, \code{colnames}, \code{rowtype}, \code{coltype}, or \code{values}
are silently dropped.
\code{rowtypes} and \code{coltypes} are added as attributes to the resulting matrix
(via \code{matsbyname::setrowtype()} and \code{matsbyname::setcoltype()}.
The resulting matrix is a (under the hood) a data frame.
If both \code{rownames} and \code{colnames} columns of \code{.DF} contain \code{NA},
it is assumed that this is a single value, not a matrix,
in which case the value in the \code{values} column is returned.
}
\details{
Note that two types of matrices can be created, a \code{matrix} or a \code{Matrix}.
\code{Matrix} has the advantage of representing sparse matrices with less memory
(and disk space).
\code{Matrix} objects are created by \code{matsbyname::Matrix()}.
}
\examples{
library(matsbyname)
library(dplyr)
data <- data.frame(Country  = c("GH", "GH", "GH"),
                   rows = c( "c 1",  "c 1", "c 2"),
                   cols = c( "i 1",  "i 2", "i 2"),
                   vals = c(   11  ,   12,    22 ))
A <- rowcolval_to_mat(data, rownames = "rows", colnames = "cols", matvals = "vals")
A
rowtype(A) # NULL, because types not set
coltype(A) # NULL, because types not set
B <- rowcolval_to_mat(data, rownames = "rows", colnames = "cols", matvals = "vals",
                            rowtypes  = "Commodities", coltypes  = "Industries")
B
C <- data \%>\% bind_cols(data.frame(rt = c("Commodities", "Commodities", "Commodities"),
                                   ct = c("Industries", "Industries", "Industries"))) \%>\%
  rowcolval_to_mat(rownames = "rows", colnames = "cols", matvals = "vals",
                   rowtypes = "rt", coltypes = "ct")
C
# Also works for single values if both the rownames and colnames columns contain NA
data2 <- data.frame(Country = c("GH"), rows = c(NA), cols = c(NA),
  rowtypes = c(NA), coltypes = c(NA), vals = c(2))
data2 \%>\% rowcolval_to_mat(rownames = "rows", colnames = "cols", matvals = "vals",
  rowtypes = "rowtypes", coltypes = "coltypes")
data3 <- data.frame(Country = c("GH"), rows = c(NA), cols = c(NA), vals = c(2))
data3 \%>\% rowcolval_to_mat(rownames = "rows", colnames = "cols", matvals = "vals")
# Fails when rowtypes or coltypes not all same. In data3, column rt is not all same.
data4 <- data \%>\% bind_cols(data.frame(rt = c("Commodities", "Industries", "Commodities"),
                                       ct = c("Industries", "Industries", "Industries")))
\dontrun{rowcolval_to_mat(data4, rownames = "rows", colnames = "cols",
                          matvals = "vals", rowtypes = "rt", coltypes = "ct")}
}
