% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{rmatrixnormal}
\alias{rmatrixnormal}
\title{Matrix normal sampler}
\usage{
rmatrixnormal(n, M, U, V, checkSymmetry = TRUE, keep = TRUE)
}
\arguments{
\item{n}{sample size, a positive integer}

\item{M}{mean matrix, without constraints}

\item{U}{columns covariance matrix, a positive semidefinite matrix of order equal
to \code{nrow(M)}}

\item{V}{rows covariance matrix, a positive semidefinite matrix of order equal
to \code{ncol(M)}}

\item{checkSymmetry}{logical, whether to check the symmetry of \code{U} and \code{V}}

\item{keep}{logical, whether to return an array with class \pkg{\link[keep]{keep}}}
}
\value{
A numeric three-dimensional array;
simulations are stacked along the third dimension (see example).
}
\description{
Samples the matrix normal distribution.
}
\examples{
m <- 3
p <- 2
M <- matrix(1, m, p)
U <- toeplitz(m:1)
V <- toeplitz(p:1)
MNsims <- rmatrixnormal(10000, M, U, V)
dim(MNsims) # 3 2 10000
apply(MNsims, 1:2, mean) # approximates M
vecMNsims <- t(apply(MNsims, 3, function(X) c(t(X))))
round(cov(vecMNsims)) # approximates kronecker(U,V)
}
