% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.boot.R
\name{matrixpls.boot}
\alias{matrixpls.boot}
\title{Bootstrapping of matrixpls function}
\usage{
matrixpls.boot(data, ..., R = 500, signChangeCorrection = NULL,
  parallel = c("no", "multicore", "snow"), ncpus = getOption("boot.ncpus",
  1L), stopOnError = FALSE, extraFun = NULL)
}
\arguments{
\item{data}{Matrix or data frame containing the raw data.}

\item{...}{All other arguments are passed through to \code{\link{matrixpls}}.}

\item{R}{Number of bootstrap samples to draw.}

\item{signChangeCorrection}{Sign change correction function.}

\item{parallel}{
    The type of parallel operation to be used (if any).  If missing, the
    default is taken from the option \code{"boot.parallel"} (and if that
    is not set, \code{"no"}).
  }

\item{ncpus}{
    integer: number of processes to be used in parallel operation:
    typically one would chose this to the number of available CPUs.
  }

\item{stopOnError}{A logical indicating whether boostrapping should be continued when error occurs
in a replication.}

\item{extraFun}{A function that takes a \code{matrixpls} object and returns a numeric vector. The
vector is appended to bootstrap replication. Can be used for boostrapping additional
statistics calculated based on the estimation results.}
}
\value{
An object of class \code{\link[boot]{boot}}.
}
\description{
\code{matrixpls.boot} is a convenience method that implements bootstrapping of \code{matrixpls}
with \code{\link[boot]{boot}} method of the \code{boot} package.
}
\seealso{
\code{\link[boot]{boot}}

Sign change corrections: \code{\link{signChange.individual}}; \code{\link{signChange.construct}}
}

