% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isfield.R
\name{isfield}
\alias{isfield}
\title{Checks if a list contains a field}
\usage{
isfield(x, field)
}
\arguments{
\item{x}{list}

\item{field}{name of field}
}
\value{
A logical vector determining if \code{field} is within
\code{names(x)}
}
\description{
This function tries to replicate the behavior of the \code{isfield}
function in Matlab
}
\examples{
S <- list(
  x = rnorm(100),
  title = "x"
)
isfield(S, "title")
isfield(S, "z")
}
\references{
https://se.mathworks.com/help/matlab/ref/isfield.html
}
