/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector;

import choco.Choco;
import choco.cp.common.util.preprocessor.AbstractAdvancedDetector;
import choco.cp.common.util.preprocessor.ExpressionTools;
import choco.cp.model.CPModel;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.preprocessor.PreProcessCPSolver;
import choco.kernel.model.constraints.AbstractConstraint;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.MetaConstraint;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.constraints.SConstraint;
import java.util.Iterator;
import java.util.LinkedList;

public class ExpressionSolverDetector
extends AbstractAdvancedDetector {
    private final PreProcessCPSolver ppsolver;

    public ExpressionSolverDetector(CPModel model, PreProcessCPSolver solver) {
        super(model);
        this.ppsolver = solver;
    }

    @Override
    public void apply() {
        Iterator<Constraint> it = this.model.getConstraintIterator();
        LinkedList<Constraint> neqToAdd = new LinkedList<Constraint>();
        while (it.hasNext()) {
            Constraint ic = it.next();
            if (this.ppsolver.contains(ic) || !ExpressionSolverDetector.isAValidExpression(ic)) continue;
            ExpressionSConstraint c = new ExpressionSConstraint(this.ppsolver.getMod2Sol().buildNode(ic));
            c.setScope(this.ppsolver);
            this.ppsolver.getMod2Sol().storeExpressionSConstraint(ic, c);
            SConstraint intensional = ExpressionTools.getIntentionalConstraint(c, this.ppsolver);
            if (intensional != null) {
                c.setKnownIntensionalConstraint(intensional);
                continue;
            }
            if (!ExpressionTools.encompassDiff(c)) continue;
            IntegerVariable[] vars = ((AbstractConstraint)ic).getIntVariableScope();
            neqToAdd.add(Choco.neq((IntegerExpressionVariable)vars[0], (IntegerExpressionVariable)vars[1]));
        }
        for (Constraint aNeqToAdd : neqToAdd) {
            this.model.addConstraint(aNeqToAdd);
        }
    }

    private static boolean isAValidExpression(Constraint ic) {
        return ic instanceof MetaConstraint || ic instanceof ComponentConstraint && (ic.getConstraintType() == ConstraintType.EQ || ic.getConstraintType() == ConstraintType.NEQ || ic.getConstraintType() == ConstraintType.LEQ || ic.getConstraintType() == ConstraintType.GEQ || ic.getConstraintType() == ConstraintType.GT || ic.getConstraintType() == ConstraintType.LT);
    }
}

