/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.tools;

import choco.kernel.common.util.iterators.AppendIterator;
import choco.kernel.common.util.iterators.ArrayIterator;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.common.util.iterators.ImmutableListIterator;
import choco.kernel.common.util.iterators.SingleElementIterator;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class IteratorUtils {
    public static <E> ListIterator<E> setImmutableIterator(ListIterator<E> iter) {
        return new ImmutableListIterator<E>(iter);
    }

    public static <E> ListIterator<E> getImmutableIterator(List<E> list) {
        return IteratorUtils.setImmutableIterator(list.listIterator());
    }

    public static <E> DisposableIterator<E> iterator(E elem) {
        return SingleElementIterator.getIterator(elem);
    }

    public static <E> DisposableIterator<E> iterator(E[] array) {
        return ArrayIterator.getIterator(array, array.length);
    }

    public static <E> Iterator<E> append(Iterator<E> ... iters) {
        return new AppendIterator<E>(iters);
    }

    public static <E> Iterator<E> iterator(List<E> ... lists) {
        Iterator[] iters = (Iterator[])Array.newInstance(Iterator.class, lists.length);
        for (int i = 0; i < lists.length; ++i) {
            iters[i] = IteratorUtils.getImmutableIterator(lists[i]);
        }
        return IteratorUtils.append(iters);
    }

    public static Iterator<Variable> variableIterator(Iterator<? extends Variable> ... iters) {
        return new AppendIterator<Variable>(iters);
    }

    public static <E> Iterator<E> appendAndCast(Iterator<? extends E> ... iters) {
        return new AppendIterator<E>(iters);
    }

    public static <E> Iterator<E> append(E[] ... arrays) {
        Iterator[] iters = (Iterator[])Array.newInstance(Iterator.class, arrays.length);
        for (int i = 0; i < arrays.length; ++i) {
            iters[i] = IteratorUtils.iterator(arrays[i]);
        }
        return IteratorUtils.append(iters);
    }

    public static Iterator<Constraint> iterator(final Model m, final Collection<Constraint> constraints) {
        return new Iterator<Constraint>(){
            Constraint c;
            final Iterator<Constraint> it;
            {
                this.it = constraints.iterator();
            }

            @Override
            public boolean hasNext() {
                block2: {
                    do {
                        if (this.it == null) {
                            return false;
                        }
                        if (!this.it.hasNext()) break block2;
                        this.c = this.it.next();
                    } while (!Boolean.TRUE.equals(m.contains(this.c)));
                    return true;
                }
                return false;
            }

            @Override
            public Constraint next() {
                return this.c;
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }
}

