/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.channeling;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class ReifiedBinXor
extends AbstractTernIntSConstraint {
    public ReifiedBinXor(IntDomainVar b, IntDomainVar v1, IntDomainVar v2) {
        super(b, v1, v2);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.isInstantiated()) {
            this.filter0();
        } else {
            if (this.v1.isInstantiated()) {
                this.filter(this.v1.getVal(), this.v2);
            }
            if (this.v2.isInstantiated()) {
                this.filter(this.v2.getVal(), this.v1);
            }
        }
    }

    private void filter0() throws ContradictionException {
        switch (this.v0.getVal()) {
            case 0: {
                if (this.v1.isInstantiated()) {
                    this.v2.instantiate(this.v1.getVal(), this, false);
                    break;
                }
                if (!this.v2.isInstantiated()) break;
                this.v1.instantiate(this.v2.getVal(), this, false);
                break;
            }
            case 1: {
                if (this.v1.isInstantiated()) {
                    this.v2.instantiate(Math.abs(this.v1.getVal() - 1), this, false);
                    break;
                }
                if (!this.v2.isInstantiated()) break;
                this.v1.instantiate(Math.abs(this.v2.getVal() - 1), this, false);
            }
        }
    }

    private void filter(int val, IntDomainVar v) throws ContradictionException {
        switch (val) {
            case 0: {
                if (!v.isInstantiated()) break;
                this.v0.instantiate(v.getVal(), this, false);
                break;
            }
            case 1: {
                if (!v.isInstantiated()) break;
                this.v0.instantiate(Math.abs(v.getVal() - 1), this, false);
            }
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        switch (idx) {
            case 0: {
                this.filter0();
                break;
            }
            case 1: {
                this.filter(this.v1.getVal(), this.v2);
                break;
            }
            case 2: {
                this.filter(this.v2.getVal(), this.v1);
            }
        }
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        if (tuple[0] == 0) {
            return tuple[1] == tuple[2];
        }
        return tuple[1] != tuple[2];
    }

    @Override
    public Boolean isEntailed() {
        if (this.v0.isInstantiated() && this.v1.isInstantiated() && this.v2.isInstantiated()) {
            return this.v0.getVal() == this.v1.getVal() + this.v2.getVal();
        }
        return null;
    }
}

