% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaa.R
\name{iaa}
\alias{iaa}
\title{Immediate Acceptance Algorithm (a.k.a. Boston mechanism) for two-sided matching markets}
\usage{
iaa(nStudents = ncol(s.prefs), nColleges = ncol(c.prefs), nSlots = rep(1,
  nColleges), s.prefs = NULL, c.prefs = NULL, acceptance = "immediate")
}
\arguments{
\item{nStudents}{integer indicating the number of students (in the college admissions problem) 
or men (in the stable marriage problem) in the market. Defaults to \code{ncol(s.prefs)}.}

\item{nColleges}{integer indicating the number of colleges (in the college admissions problem) 
or women (in the stable marriage problem) in the market. Defaults to \code{ncol(c.prefs)}.}

\item{nSlots}{vector of length \code{nColleges} indicating the number of places (i.e. 
quota) of each college. Defaults to \code{rep(1,nColleges)} for the marriage problem.}

\item{s.prefs}{matrix of dimension \code{nColleges} \code{x} \code{nStudents} with the \code{j}th 
column containing student \code{j}'s ranking over colleges in decreasing order of 
preference (i.e. most preferred first).}

\item{c.prefs}{matrix of dimension \code{nStudents} \code{x} \code{nColleges} with the \code{i}th 
column containing college \code{i}'s ranking over students in decreasing order of 
preference (i.e. most preferred first).}

\item{acceptance}{if \code{acceptance="deferred"} returns the solution found by the student-proposing Gale-Shapley deferred acceptance algorithm; if \code{acceptance="immediate"} (the default) returns the solution found by the Boston mechanism.}
}
\value{
\code{iaa} returns a list with the following elements.
\item{s.prefs}{student-side preference matrix.}
\item{c.prefs}{college-side preference matrix.}
\item{iterations}{number of interations required to find the stable matching.}
\item{matchings}{edgelist of matches}
\item{singles}{identifier of single (or unmatched) students/men.}
}
\description{
Finds the optimal assignment of students to colleges in the 
\href{http://en.wikipedia.org/wiki/Hospital_resident}{college admissions} problem
based on the Boston mechanism. The option \code{acceptance="deferred"} instead uses the Gale-Shapley 
(1962) Deferred Acceptance Algorithm with male offer. The function works with either 
given or randomly generated preferences.
}
\section{Minimum required arguments}{

\code{iaa} requires the following combination of arguments, subject to the matching problem.
\describe{
\item{\code{nStudents, nColleges}}{Marriage problem with random preferences.}
\item{\code{s.prefs, c.prefs}}{Marriage problem with given preferences.}
\item{\code{nStudents, nSlots}}{College admissions problem with random preferences.}
\item{\code{s.prefs, c.prefs, nSlots}}{College admissions problem with given preferences.}
}
}

\examples{
## --------------------------------
## --- College admission problem

## Boston mechanism for 7 students, 2 colleges with 3 slots each
 set.seed(123)
 iaa(nStudents=7, nSlots=c(3,3))

## Gale-Shapley algorithm
 set.seed(123)
 iaa(nStudents=7, nSlots=c(3,3), acceptance="deferred")

## Same results for the Gale-Shapley algorithm with hri() function
 set.seed(123)
 hri(nStudents=7, nSlots=c(3,3))

## 7 students, 2 colleges with 3 slots each, given preferences:
 s.prefs <- matrix(c(1,2, 1,2, 1,2, 1,2, 1,2, 1,2, 1,2), 2,7)
 c.prefs <- matrix(c(1,2,3,4,5,6,7, 1,2,3,4,5,6,7), 7,2)
 iaa(s.prefs=s.prefs, c.prefs=c.prefs, nSlots=c(3,3))
}
\references{
Gale, D. and Shapley, L.S. (1962). College admissions and the stability 
of marriage. \emph{The American Mathematical Monthly}, 69(1):9--15.

Kojima, F. and M.U. Unver (2014). The "Boston" school-choice mechanism. \emph{Economic Theory}, 55(3): 515--544.
}
\author{
Thilo Klein
}
\keyword{algorithms}
