% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mb_get_balance.R
\name{mb_get_balance}
\alias{mb_get_balance}
\title{Get List of Current Bets on Matchbook}
\usage{
mb_get_balance(session_data)
}
\arguments{
\item{session_data}{A session object returned from a successful mb_login attempt. It contains details about your user preferences and security details.}
}
\value{
If successful, a list with account balance information. 
The data frame has the following fields:
 \describe{
  \item{id}{the account id}
  \item{balance}{the account balance in the currency of the account}
  \item{exposure}{the account exposure in the currency of the account}
  \item{commission-reserve}{the commission-reserve in the currency of the account}
  \item{free-funds}{the free-funds in the currency of the account}
}
}
\description{
Get account balance/exposure etc.
}
\examples{
\dontrun{my_session <- mb_login("my_user_name","my_password"); 
mb_get_balance(session_data=my_session)}

}
\seealso{
\code{\link{mb_login}}
}

