% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_list_from_scratch_overall.R
\name{create_list_from_scratch_overall}
\alias{create_list_from_scratch_overall}
\title{Create a sparse list representation of treated-to-control distance
matrix with a fixed number caliper with L1-distance.}
\usage{
create_list_from_scratch_overall(
  Z,
  X,
  exact = NULL,
  soft_exact = FALSE,
  p = NULL,
  caliper_low = NULL,
  caliper_high = NULL,
  k = NULL,
  penalty = Inf,
  dist_func = NULL
)
}
\arguments{
\item{Z}{A length-n vector of treatment indicator.}

\item{X}{A n-by-p matrix of covariates.}

\item{exact}{A vector of strings indicating which variables are to be exactly matched.}

\item{soft_exact}{If set to TRUE, the exact constraint is enforced up to a large penalty.}

\item{p}{A length-n vector on which a caliper applies, e.g. a vector of propensity score.}

\item{caliper_low}{Size of caliper_inf.}

\item{caliper_high}{Size of caliper_sup.}

\item{k}{Connect each treated to the nearest k controls}

\item{penalty}{Penalty for violating the caliper. Set to Inf by default.}

\item{dist_func}{A function used to calculate distance}
}
\value{
This function returns a list of three objects: start_n, end_n, and d.
        See documentation of function ``create_list_from_mat'' for more details.
}
\description{
This function takes in a n-by-p matrix of observed covariates,
a length-n vector of treatment indicator, a caliper, and construct
a possibly sparse list representation of the distance matrix with
Mahalanobis distance. Note that this function is of limited interest
to most users.
}
