% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_outcome.R
\name{construct_outcome}
\alias{construct_outcome}
\title{Construct an output for matching.}
\usage{
construct_outcome(res, dist_list_1, Z, dataset, controls = 1)
}
\arguments{
\item{res}{A callrelax output.}

\item{dist_list_1}{A possibly sparse representation of the first distance matrix.}

\item{Z}{A vector of treatment status.}

\item{dataset}{The original dataset.}

\item{controls}{Number of controls matched to each treated.}
}
\value{
This function returns a list of three objects: 1) feasible: 0/1 depending on the
feasibility of the matching problem; 2) data_with_matched_set_ind: a dataframe that is the
same as the original dataframe, except that a column called matched_set and a column
called distance are added to it. The column matched_set assigns 1,2,...,n_t to each matched
set, and NA to those not matched to any treated. Variable distance records the distance
(as specified in the left network) between each matched control and the treated, and assigns NA
to all treated and cotnrols that are left unmatched. If matching is not feasible, NULL will be returned;
3) matched_data_in_order:a dataframe organized in the order of matched sets and otherwise the
same as data_with_matched_set_ind. Note that the matched_set column assigns 1,2,...,n_t for
as indices for matched sets, and NA for those controls that are not paired. Null will be returned
if the matching is infeasible.
}
\description{
This function constructs the output given the relaxsolution
to the associated network flow problem and the original dataset.
This function is typically of little interest to users.
}
