% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closed_figures.R, R/lines.R
\name{luck}
\alias{luck}
\alias{luck4}
\title{Coordinates of a luck}
\usage{
luck(
  size.x = 10,
  size.y = 15,
  rot = pi/2,
  pos.x = 0,
  pos.y = 0,
  shd = NA,
  vis = 1,
  lty = 1,
  lwd = 3
)

luck4(size.x = 10, size.y = 7, lwd = 3, lty = 1)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is 10}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is 7}

\item{rot}{define the rotation. Default is \eqn{\frac{\pi}{2}}}

\item{pos.x}{numeric, position on the x axis. Default is 0}

\item{pos.y}{numeric, position the y axis, Default is 0}

\item{shd}{character, define the shading of the figure. Default is NA which results in a transparent figure}

\item{vis}{Visibility of the figure. Default is 1, making the figure visible. To hide the figure, change it to 0}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line)}

\item{lwd}{integer, define the line width of the figure. Default is 3}
}
\value{
Return the coordinates for drawing a luck

Return the coordinates for drawing a luck composed of 4 lines
}
\description{
Define the coordinates  for drawing a luck of the ellipse within which a luck can be inscribed.
}
\section{Functions}{
\itemize{
\item \code{luck4()}: Coordinates of a luck composed of 4 lines

Define the coordinates for drawing of a luck composed of 4 lines

}}
\examples{
# return the default coordinates for drawing a luck
luck()
# change the coordinates for drawing a smaller luck
luck(size.x = 10, size.y = 15)
# default coordinates of an luck composed of 4 lines
luck4()
# draw a luck composed of 4 lines with different lty
draw(luck4(lty = 2))
}
