% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{mash_plot_meta}
\alias{mash_plot_meta}
\title{Plot metaplot for an effect based on posterior from mash}
\usage{
mash_plot_meta(m, i, xlab = "Effect size", ylab = "Condition", ...)
}
\arguments{
\item{m}{the result of a mash fit}

\item{i}{index of the effect to plot}

\item{xlab}{Character string specifying x-axis label.}

\item{ylab}{Character string specifying y-axis label.}

\item{...}{Additional arguments passed to \code{\link[rmeta]{metaplot}}.}
}
\description{
Plot metaplot for an effect based on posterior from mash
}
\examples{
simdata = simple_sims(50,5,1)
data = mash_set_data(simdata$Bhat, simdata$Shat)
m = mash(data, cov_canonical(data))
mash_plot_meta(m,1)

}
