% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postStrat.R
\name{postStrat}
\alias{postStrat}
\title{Compute a post-stratified estimator}
\usage{
postStrat(y, x_sample, x_pop, pi = NULL, N = NULL, var_est = FALSE,
  var_method = "lin_HB", pi2 = NULL, data_type = "raw", B = 1000,
  strata = NULL)
}
\arguments{
\item{y}{A numeric vector of the sampled response variable.}

\item{x_sample}{A vector containing the post-stratum for each sampled unit.}

\item{x_pop}{A vector or data frame, depending on data_type.  If data_type = "raw", then a vector containing the post-stratum for each population unit.  If data_type = "totals" or "means", then a data frame, where the first column lists the possible post-strata and the second column contains the population total or proportion in each post-stratum.}

\item{pi}{A numeric vector of inclusion probabilities for each sampled unit in y.  If NULL, then simple random sampling without replacement is assumed.}

\item{N}{A numeric value of the population size. If NULL, it is estimated with the sum of the inverse of the pis.}

\item{var_est}{Default to FALSE, logical for whether or not to compute estimate of variance}

\item{var_method}{The method to use when computing the variance estimator.  Options are a Taylor linearized technique: "lin_HB"= Hajek-Berger estimator, "lin_HH" = Hansen-Hurwitz estimator, "lin_HTSRS" = Horvitz-Thompson estimator under simple random sampling without replacement, and "lin_HT" = Horvitz-Thompson estimator or a resampling technique: "bootstrap_SRS" = bootstrap variance estimator under simple random sampling without replacement, "unconditional_SRS" = simple random sampling variance estimator which accounts for random strata.}

\item{pi2}{A square matrix of the joint inclusion probabilities.  Needed for the "lin_HT" variance estimator.}

\item{data_type}{Default to "raw", takes values "raw", "totals" or "means" for whether the user is providing the raw population stratum memberships, the population totals of each stratum, or the population proportions of each stratum.}

\item{B}{The number of bootstrap samples if computing the bootstrap variance estimator.  Default is 1000.}

\item{strata}{A factor vector of the stratum membership.  If NULL, all units are put into the same stratum.  Must have same length as y.}
}
\value{
A list of output containing:
\itemize{
\item{pop_total: Estimate of population total}
\item{pop_mean: Estimate of the population mean}
\item{pop_total_var: Estimated variance of population total estimate}
\item{pop_mean_var: Estimated variance of population mean estimate}
\item{strat_ests: Table of total and mean estimates for each strata}
\item{weights: Survey weights produced by post stratification}
}
}
\description{
Calculates a generalized regression estimator for a finite population mean/proportion or total based on sample data collected from a complex sampling design and auxiliary population data.
}
\examples{
library(survey)
data(api) 
postStrat(y = apisrs$api00, x_sample = apisrs$awards, 
x_pop = data.frame(table(apipop$awards)), data_type = "totals", 
pi = apisrs$pw^(-1))

}
\references{
\insertRef{coc77}{mase} 

\insertRef{sar92}{mase}
}
\seealso{
\code{\link{greg}} for a linear or logistic regression model.
}
