% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pllog.R
\name{pllog}
\alias{pllog}
\title{Probability function of Log-Logistics model}
\usage{
pllog(q, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{q}{input quantile for Log-Logistics model}

\item{shape}{shape parameter of Log-Logistics model}

\item{scale}{scale parameter of Log-Logistics model}

\item{lower.tail}{logic function to determine whether lower tail probability to be returned}

\item{log.p}{logic function to determine whether log of logistics to be returned}
}
\value{
returns the probability of the Log-Logistics model
}
\description{
Probability function of Log-Logistics model
}
\examples{
q <- c(1, 2, 3, 4)
# set paramters
shape <- 5
scale <- 3
log <- FALSE
result_1 <- marp::pllog(q, shape, scale, log)

# alternatively, set log == TRUE
log <- TRUE
result_2 <-  marp::pllog(q, shape, scale, log)

}
