# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Split sequences into sub-sequences of fixed length
#'
#' \code{split_seq} splits sequences into sub-sequences of fixed length,
#' by applying a sliding window at step of 1. If the length of a sequence
#' is less than the fixed length, NA values are added to the end
#' of its only sub-sequence.
#'
#' @param seq_list List of integer vectors as sequences, usually converted
#' from factors.
#' @param len Integer as the length of sub-sequences.
#'
#' @return A nested list of integer vectors as sub-sequences, with each
#' integer vector in the input replaced by a list of integer vectors as
#' its sub-sequences.
#'
#' @note Change log:
#' \itemize{
#'   \item{0.1.0 Xiurui Zhu - Initiate the function.}
#'   \item{0.1.2 Xiurui Zhu - Add the documentation.}
#' }
#' @author Xiurui Zhu
#'
#' @family low level C++ functions to fit Markov chains.
#'
#' @noRd
split_seq <- function(seq_list, len) {
    .Call(`_markovmix_split_seq`, seq_list, len)
}

#' Compute column sums by group
#'
#' \code{colsums_by_group} computes column sums by group.
#'
#' @param value_list List of numeric vectors, usually generated by calling
#' \code{\link{split}} on a matrix.
#' @param n_col Integer as the number of columns of the original matrix.
#'
#' @return A numeric matrix with each row as the column sums of a group.
#'
#' @note Change log:
#' \itemize{
#'   \item{0.1.0 Xiurui Zhu - Initiate the function.}
#'   \item{0.1.2 Xiurui Zhu - Add the documentation.}
#' }
#' @author Xiurui Zhu
#'
#' @family low level C++ functions to fit Markov chains.
#'
#' @noRd
colsums_by_group <- function(value_list, n_col) {
    .Call(`_markovmix_colsums_by_group`, value_list, n_col)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_markovmix_RcppExport_registerCCallable', PACKAGE = 'markovmix')
})
