% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/market_fit.R
\name{ncoef}
\alias{ncoef}
\alias{ncoef,market_model-method}
\alias{ncoef,market_fit-method}
\title{Number of coefficients}
\usage{
ncoef(object)

\S4method{ncoef}{market_model}(object)

\S4method{ncoef}{market_fit}(object)
}
\arguments{
\item{object}{A model object.}
}
\value{
The number of model coefficients.
}
\description{
Returns the number of model's coefficients. This is the sum of demand, supply, price
equation, and the variance-covariance matrix coefficients.
}
\examples{
\donttest{
model <- new(
  "diseq_basic", # model type
  subject = ID, time = TREND, quantity = HS, price = RM,
  demand = RM + TREND + W + CSHS + L1RM + L2RM + MONTH,
  supply = RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses()
)

# get the number of model coefficients
ncoef(model)
}
}
