% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_fit.R
\docType{class}
\name{market_fits}
\alias{market_fits}
\alias{market_fit-class}
\title{Market model fit}
\description{
This is the estimation output class for all market models of the package. It couples
a market model object with estimation results. It provides a common user interface
for accessing estimation results, irrespective of the underlying market model used.
The estimation results are intended to be accessed by passing \code{market_fit}
objects to methods such as \code{\link{plot}}, \code{\link{summary}}, and
\code{\link{logLik}}.
}
\details{
The \code{market_fit} class derives from the \code{\linkS4class{market_model}}
class. Thus, all the public functionality of the underlying market model is also
directly accessible from the output class.

Furthermore, the class is responsible for harmonizing the heterogeneous
outputs resulting from different estimation methods of market models. For
example, a \code{2SLS} estimation of the
\code{\linkS4class{equilibrium_model}} returns a list of linear regression
models (the first stage, demand, and supply models), while the maximum
likelihood estimation of \code{\linkS4class{diseq_basic}} returns an
\code{\link[stats]{optim}} list. In both cases, the \code{market_fit}
stores the estimation output in the member \code{fit} of type \code{list}.
Methods of the class examine the type of the \code{fit} and direct
execution accordingly to different branches to produce
a unified experience for the caller.
}
\section{Functions}{
\itemize{
\item \code{market_fit-class}: Fit class for market models
}}

\section{Slots}{

\describe{
\item{\code{model}}{The underlying market model object.}

\item{\code{fit}}{A list holding estimation outputs.}
}}

\examples{
# estimate an equilibrium  model using the houses dataset
fit <- equilibrium_model(
  HS | RM | ID | TREND ~
    RM + TREND + W + CSHS + L1RM + L2RM + MONTH |
      RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(),
  estimation_options = list(method = "2SLS")
)

# access an inherited method from the underlying model
aggregate_demand(fit)

# summary of results
summary(fit)
}
\seealso{
\code{\linkS4class{market_model}}
}
