% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/equilibrium_model.R
\name{maximize_log_likelihood}
\alias{maximize_log_likelihood}
\alias{maximize_log_likelihood,equilibrium_model-method}
\title{Maximize the log-likelihood.}
\usage{
maximize_log_likelihood(
  object,
  start,
  step,
  objective_tolerance,
  gradient_tolerance,
  max_it
)

\S4method{maximize_log_likelihood}{equilibrium_model}(
  object,
  start,
  step,
  objective_tolerance,
  gradient_tolerance,
  max_it
)
}
\arguments{
\item{object}{A model object.}

\item{start}{Initializing vector.}

\item{step}{Optimization step.}

\item{objective_tolerance}{Objective optimization tolerance.}

\item{gradient_tolerance}{Gradient optimization tolerance.}

\item{max_it}{Maximum allowed number of iterations.}
}
\value{
A list with the optimization output.
}
\description{
Maximizes the log-likelihood using the
\href{https://www.gnu.org/software/gsl/doc/html/multimin.html}{\code{GSL}}
implementation of the BFGS algorithm. This function is primarily intended for
advanced usage. The \code{\link{estimate}} functionality is a fast,
analysis-oriented alternative. If the
\href{https://www.gnu.org/software/gsl/doc/html/multimin.html}{\code{GSL}} is not
available, the function returns a trivial result list with status set equal to -1.
If the
\href{https://en.cppreference.com/w/cpp/algorithm/execution_policy_tag_t}{C++17
execution policies}
are available, the implementation of the optimization is parallelized.
}
\examples{
\donttest{
model <- simulate_model(
  "equilibrium_model", list(
    # observed entities, observed time points
    nobs = 500, tobs = 3,
    # demand coefficients
    alpha_d = -0.9, beta_d0 = 14.9, beta_d = c(0.3, -0.2), eta_d = c(-0.03, -0.01),
    # supply coefficients
    alpha_s = 0.9, beta_s0 = 3.2, beta_s = c(0.03), eta_s = c(0.05, 0.02)
  ),
  seed = 99
)

# maximize the model's log-likelihood
mll <- maximize_log_likelihood(
  model,
  start = NULL, step = 1e-5,
  objective_tolerance = 1e-4, gradient_tolerance = 1e-3, max_it = 1e+3
)
mll
}
}
\seealso{
\code{\link{estimate}}
}
