% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identical.R
\name{are_identical}
\alias{are_identical}
\title{Identical extensions}
\usage{
are_identical(..., params = NULL)
}
\arguments{
\item{...}{Vectors of values to compare, element-wise of equal length}

\item{params}{Additional params (as a named list of arguments for
\link[base:identical]{base::identical})}
}
\value{
A \code{logical} vector of \code{TRUE}/\code{FALSE} of equal length of each \code{...}
vector
}
\description{
Extensions for the use of \code{base::identical()}
}
\examples{
x <- y <- z <- 1:5
y[2] <- 3L
z[5] <- NA_integer_

identical(x, y)        # compare entire vector
are_identical(x, y)    # element-wise
are_identical(x, y, z) # 3 or more vectors
}
