% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speciesRichness.R
\name{speciesRichness}
\alias{speciesRichness}
\title{Calculates Species Richness of the community or the Diversity of Target
 Species}
\usage{
speciesRichness(X, groups, species.table = NULL, metric, years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
 survey data or model output, OR commercial landings data. Fishery
 independent survey data has columns \code{YEAR}, \code{ID}, \code{SPECIES},
 and \code{ABUNDANCE} and/or \code{BIOMASS}. \code{YEAR} indicates the year
 the observation was recorded, \code{ID} is an area code indicating where the
 observation was recorded, \code{SPECIES} is a numeric code indicating the
 species sampled, and \code{ABUNDANCE}/\code{BIOMASS} is the corresponding
 abundance/biomass (stratified and corrected for catchability as required).

 Similarly, commercial landings data should have columns \code{YEAR},
 \code{ID}, \code{SPECIES} are as above, and \code{CATCH} is the
 corresponding landed weight.}

\item{groups}{A vector indicating the species group(s) for which to calculate
the indicator. If \code{groups = "ALL"}, all species will be included;
otherwise, each entry must be a character string matching the name of a
column in \code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate the indicator. Default is \code{metric = "ABUNDANCE"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with columns \code{ID} and \code{YEAR}, and if
 \code{metric = "ABUNDANCE"}, a column \code{SpeciesRichness_group} for each
 entry in \code{groups} OR if \code{metric = "CATCH"}, a column
 \code{DiversityTargetSpp_group} for each entry in \code{groups}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 values is assigned \code{NA}.
}
\description{
This function counts the number of species recorded in fishery
 independent survey data or commercial landings data for \eqn{i} years and
 \eqn{j} areas.
}
\details{
Two useful species richness indicators are: "Species Richness" (S) of
 the surveyed community in an area and "Diversity of the Target Species" (TS)
 in the commercial fishery, which is a measure of the distribution of fishing
 pressure.

 Species richness (\eqn{S_y}) is the count of the number of species recorded
 in all research vessel trawl surveys collected in year \eqn{y} for a given
 area (Hurlbert, 1971).

 The diversity of the target species for year y (\eqn{TS_y}) is the count of
 the number of target species recorded in all trawl catches collected in that
 year for a given area.
}
\examples{
# Calculate species richness (community)
data(X)
speciesRichness(X, groups = "ALL", metric = "BIOMASS", years = c(2014:2019))

# Calculate diversity of target species
data(land)
speciesRichness(land, groups = "ALL", metric = "CATCH",  years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Hurlbert SH. 1971. The non-concept of species diversity: a critique and
 alternative parameters. Ecology, 52, 577-86.
}
\seealso{
Other biodiversity indicators: \code{\link{allBiodiversity}},
  \code{\link{heips}}, \code{\link{hillN1}},
  \code{\link{hillN2}}, \code{\link{kemptonQ}},
  \code{\link{margalef}}, \code{\link{pielouEvenness}},
  \code{\link{shannon}}

Other fishing pressure indicators: \code{\link{allPressure}},
  \code{\link{fishingPressure}}, \code{\link{landings}},
  \code{\link{meanTLLandings}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{biodiversity indicators}
\concept{fishing pressure indicators}
