% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/defining.programs.R
\name{define.sum}
\alias{define.sum}
\title{define.sum}
\usage{
define.sum(series = NULL, difference = NULL, averages = 0)
}
\arguments{
\item{series}{= series to be summed up.}

\item{difference}{= differencing pattern (see define.dif).}

\item{averages}{of the individual series that (usually) have
been subtracted when differencing the time series (if so,
the averages are supplied in the output from define.dif(...).}
}
\value{
sum.series = the summed series.
}
\description{
Function to aggregate multivariate time series.
Reverse of function 'define.dif'.
}
\examples{
set.seed(4711)
y<-round(matrix(100*rnorm(48),nrow=4))
difference=matrix(c(1,1, 1,1, 2,1, 3,6),nrow=2)
dy<-define.dif(y,difference)$dif.series
averages<-define.dif(y,difference)$averages
sum.y<-define.sum(dy,difference,averages)$series.sum
y
dy
averages
sum.y
}

