% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.margins}
\alias{plot.margins}
\title{Plot Marginal Effects Estimates}
\usage{
\method{plot}{margins}(x, pos = seq_along(marginal_effects(x, with_at =
  FALSE)), which = colnames(marginal_effects(x, with_at = FALSE)),
  labels = gsub("^dydx_", "", which), horizontal = FALSE, xlab = "",
  ylab = "Average Marginal Effect", level = 0.95, pch = 21,
  points.col = "black", points.bg = "black", las = 1, cex = 1,
  lwd = 2, zeroline = TRUE, zero.col = "gray", ...)
}
\arguments{
\item{x}{An object of class \dQuote{margins}, as returned by \code{\link{margins}}.}

\item{pos}{A numeric vector specifying the x-positions of the estimates (or y-positions, if \code{horizontal = TRUE}).}

\item{which}{A character vector specifying which marginal effect estimate to plot. Default is all.}

\item{labels}{A character vector specifying the axis labels to use for the marginal effect estimates. Default is the variable names from \code{x}.}

\item{horizontal}{A logical indicating whether to plot the estimates along the x-axis with vertical confidence intervals (the default), or along the y-axis with horizontal confidence intervals.}

\item{xlab}{A character string specifying the x-axis (or y-axis, if \code{horizontal = TRUE}) label.}

\item{ylab}{A character string specifying the y-axis (or x-axis, if \code{horizontal = TRUE}) label.}

\item{level}{A numeric value between 0 and 1 indicating the confidence level to use when drawing error bars.}

\item{pch}{The point symbol to use for plotting marginal effect point estimates. See \code{\link[graphics]{points}} for details.}

\item{points.col}{The point color to use for plotting marginal effect point estimates. See \code{\link[graphics]{points}} for details.}

\item{points.bg}{The point color to use for plotting marginal effect point estimates. See \code{\link[graphics]{points}} for details.}

\item{las}{An integer value specifying the orientation of the axis labels. See \code{\link[graphics]{par}} for details.}

\item{cex}{A numerical value giving the amount by which plotting text and symbols should be magnified relative to the default. See \code{\link[graphics]{par}} for details.}

\item{lwd}{A numerical value giving the width of error bars in points.}

\item{zeroline}{A logical indicating whether to draw a line indicating zero. Default is \code{TRUE}.}

\item{zero.col}{A character string indicating a color to use for the zero line if \code{zeroline = TRUE}.}

\item{\dots}{Additional arguments passed to \code{\link[graphics]{plot.default}}, such as \code{title}, etc.}
}
\value{
The original \dQuote{margins} object \code{x}, invisibly.
}
\description{
An implementation of Stata's \samp{marginsplot} as an S3 generic function
}
\details{
This function is invoked for its side effect: a basic dot plot with error bars displaying marginal effects as generated by \code{\link{margins}}, in the style of Stata's \samp{marginsplot} command.
}
\examples{
\dontrun{
  require("datasets")
  x <- lm(mpg ~ cyl * hp + wt, data = mtcars)
  mar <- margins(x)
  plot(mar)
}

}
\seealso{
\code{\link{margins}}, \code{\link{persp.lm}}
}
\keyword{graphics}
