% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maraca.R
\name{plot.hce}
\alias{plot.hce}
\title{Generic function to plot the hce object using plot().}
\usage{
\method{plot}{hce}(
  x,
  continuous_outcome = "C",
  arm_levels = c(active = "A", control = "P"),
  continuous_grid_spacing_x = 10,
  trans = "identity",
  density_plot_type = "default",
  vline_type = "median",
  fixed_followup_days = NULL,
  compute_win_odds = FALSE,
  theme = "maraca",
  ...
)
}
\arguments{
\item{x}{an object of S3 class 'hce'.}

\item{continuous_outcome}{A single string containing the continuous
outcome label. Default value "C".}

\item{arm_levels}{A named vector of exactly two strings, mapping the
values used for the active and control arms to the values
used in the data. The names must be "active" and "control"
in this order. Note that this parameter only need to
be specified if you have labels different from
 "active" and "control".}

\item{continuous_grid_spacing_x}{The spacing of the x grid to use for the
continuous section of the plot.}

\item{trans}{the transformation to apply to the data before plotting.
The accepted values are the same that ggplot2::scale_x_continuous}

\item{density_plot_type}{The type of plot to use to represent the density.
Accepts "default", "violin", "box" and "scatter".}

\item{vline_type}{what the vertical dashed line should represent. Accepts
"median", "mean", "none".}

\item{fixed_followup_days}{Not needed if HCE object contains information
on fixed follow-up days in the study
(column PADY or TTEfixed,
depending on hce version).
Otherwise, this argument must be specified.
Note: If argument is specified and HCE object
contains PADY or TTEfixed column, then
fixed_followup_days argument is used.}

\item{compute_win_odds}{If TRUE compute the win odds, otherwise (default)
don't compute them.}

\item{theme}{Choose theme to style the plot. The default theme is "maraca".
Options are "maraca", "maraca_old", "color1", "color2" and none".
For more details, check the vignette called
"Maraca Plots - Themes and Styling".
[companion vignette for package users](themes.html)}

\item{\dots}{not used}
}
\value{
Used for side effect. Returns ggplot2 plot of the hce object.
}
\description{
Generic function to plot the hce object using plot().
}
\examples{
Rates_A <- c(1.72, 1.74, 0.58, 1.5, 1)
Rates_P <- c(2.47, 2.24, 2.9, 4, 6)
hce_dat <- hce::simHCE(n = 2500, TTE_A = Rates_A, TTE_P = Rates_P,
             CM_A = -3, CM_P = -6, CSD_A = 16, CSD_P = 15, fixedfy = 3,
             seed = 31337)
plot(hce_dat)
plot(hce_dat, fixed_followup_days = 3 * 365)

}
