% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_export.R
\name{mf_export}
\alias{mf_export}
\title{Export a map}
\usage{
mf_export(
  x,
  filename = "map.png",
  width,
  height,
  res = 96,
  ...,
  expandBB = rep(0, 4),
  theme,
  export = "png"
)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{Raster}}

\item{filename}{path to the exported file. If the file extention is ".png" a
png graphic device is opened, if the file extension is ".svg" a svg graphic
device is opened.}

\item{width}{width of the figure (pixels for png, inches for svg)}

\item{height}{height of the figure (pixels for png, inches for svg)}

\item{res}{resolution (for png)}

\item{...}{further parameters for png or svg export}

\item{expandBB}{fractional values to expand the bounding box with, in each
direction (bottom, left, top, right)}

\item{theme}{apply a theme}

\item{export}{deprecated}
}
\value{
No return value, a map is initiated.
}
\description{
Export a map with the extent of a spatial object.
The map is exported in PNG or SVG format. If
only one of \code{width} or \code{height} is set, \code{mf_export} uses the
width/height ratio of \code{x} bounding box to find a matching ratio for
the export.
}
\examples{
mtq <- mf_get_mtq()
(filename <- tempfile(fileext = ".png"))
mf_export(mtq, filename = filename)
mf_map(mtq, add = TRUE)
dev.off()
}
