% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_segments.R
\name{extract_segments}
\alias{extract_segments}
\title{Extract *route segments* from a Google Maps Directions API response}
\usage{
extract_segments(doc)
}
\arguments{
\item{doc}{XML document with Google Maps Directions API response}
}
\value{
Line layer (class \code{sf}) representing route segments
}
\description{
Extract *route segments* from a Google Maps Directions API response
}
\examples{
library(xml2)
doc = as_xml_document(response_directions)
seg = extract_segments(doc)
plot(seg)
\dontrun{
doc = google_directions(
  origin = c(34.81127, 31.89277),
  destination = c(34.781107, 32.085003),
  alternatives = TRUE
)
seg = extract_segments(doc)
}
}
