% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_gist.R
\name{map_gist}
\alias{map_gist}
\title{Make an interactive map to view in the browser as a GitHub gist}
\usage{
map_gist(
  x,
  description = "",
  public = TRUE,
  browse = TRUE,
  lon = "longitude",
  lat = "latitude",
  name = NULL,
  ...
)
}
\arguments{
\item{x}{The data. An object of class \code{occdat}, \code{occdatind},
\code{gbif}, \code{gbif_data}, \code{SpatialPoints},
\code{SpatialPointsDataFrame}, or \code{data.frame}. The package
\pkg{spocc} needed for
the first two, and \pkg{rgbif} needed for the third. When \code{data.frame}
input, any number of columns allowed, but with at least the following:
name (the taxonomic name), latitude (in dec. deg.), longitude (in dec. deg.)}

\item{description}{Description for the Github gist, or leave to
default (=no description)}

\item{public}{(logical) Whether gist is public (default: \code{TRUE})}

\item{browse}{If \code{TRUE} (default) the map opens in your default browser.}

\item{lon, lat}{(character) Longitude and latitude variable names. Ignored
unless \code{data.frame} input to \code{x} parameter. We attempt to guess,
but if nothing close, we stop. Default: \code{longitude} and
\code{latitude}}

\item{name}{(character) the column name that contains the name to use in
creating the map. If left \code{NULL} we look for a "name" column.}

\item{...}{Further arguments passed on to \code{\link[=style_geojson]{style_geojson()}}}
}
\description{
Make an interactive map to view in the browser as a GitHub gist
}
\details{
See \code{\link[gistr:gist_auth]{gistr::gist_auth()}} for help on authentication

Does not support adding a convex hull via \code{\link[=hull]{hull()}}
}
\examples{
\dontrun{
## spocc
library("spocc")
spp <- c('Danaus plexippus', 'Accipiter striatus', 'Pinus contorta')
dat <- spocc::occ(spp, from=c('gbif','ecoengine'), limit=30,
  gbifopts=list(hasCoordinate=TRUE))

# Define colors
map_gist(dat, color=c('#976AAE','#6B944D','#BD5945'))

# Define colors and marker size
map_gist(dat, color=c('#976AAE','#6B944D','#BD5945'),
  size=c('small','medium','large'))

# Define symbols
map_gist(dat, symbol=c('park','zoo','garden'))

## rgbif
if (requireNamespace("rgbif")) {
library("rgbif")
### occ_search() output
res <- occ_search(scientificName = "Puma concolor", limit = 100)
map_gist(res)

### occ_data() output
res <- occ_data(scientificName = "Puma concolor", limit = 100)
map_gist(res)

#### many taxa
res <- occ_data(scientificName = c("Puma concolor", "Quercus lobata"), 
   limit = 30)
res
map_gist(res)
}

## data.frame
df <- data.frame(name = c('Poa annua', 'Puma concolor', 'Foo bar'),
                 longitude = c(-120, -121, -121),
                 latitude = c(41, 42, 45), stringsAsFactors = FALSE)
map_gist(df)

### usage of occ2sp()
#### SpatialPoints
spdat <- occ2sp(dat)
map_gist(spdat)
#### SpatialPointsDataFrame
spdatdf <- as(spdat, "SpatialPointsDataFrame")
map_gist(spdatdf)
}
}
