% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_map_by_steps.R
\name{framework_map}
\alias{framework_map}
\title{Design linkage map framework in two steps: i) estimating the recombination fraction with 
HMM approach for each parent separately using only markers segregating individually 
(e.g. map 1 - P1:3 x P2:0, P1: 2x4; map 2 - P1:0 x P2:3, P1:4 x P2:2); ii) merging both 
maps and re-estimate recombination fractions.}
\usage{
framework_map(
  input.seq,
  twopt,
  start.set = 10,
  thres.twopt = 10,
  thres.hmm = 30,
  extend.tail = 30,
  inflation.lim.p1 = 5,
  inflation.lim.p2 = 5,
  phase.number.limit = 10,
  tol = 0.01,
  tol.final = 0.001,
  verbose = TRUE,
  method = "hmm"
)
}
\arguments{
\item{input.seq}{object of class \code{mappoly.sequence}}

\item{twopt}{object of class \code{mappoly.twopt}}

\item{start.set}{number of markers to start the phasing procedure (default = 4)}

\item{thres.twopt}{the LOD threshold used to determine if the linkage phases compared via two-point 
analysis should be considered for the search space reduction (default = 5)}

\item{thres.hmm}{the LOD threshold used to determine if the linkage phases compared via hmm analysis 
should be evaluated in the next round of marker inclusion (default = 50)}

\item{extend.tail}{the length of the chain's tail that should be used to calculate the likelihood of 
the map. If NULL (default), the function uses all markers positioned. Even if info.tail = TRUE, 
it uses at least extend.tail as the tail length}

\item{inflation.lim.p1}{the maximum accepted length difference between the current and the previous 
parent 1 sub-map defined by arguments info.tail and extend.tail. If the size exceeds this limit, the marker will 
not be inserted. If NULL(default), then it will insert all markers.}

\item{inflation.lim.p2}{same as `inflation.lim.p1` but for parent 2 sub-map.}

\item{phase.number.limit}{the maximum number of linkage phases of the sub-maps defined by arguments info.tail 
and extend.tail. Default is 20. If the size exceeds this limit, the marker will not be inserted. If Inf, 
then it will insert all markers.}

\item{tol}{the desired accuracy during the sequential phase of each parental map (default = 10e-02)}

\item{tol.final}{the desired accuracy for the final parental map (default = 10e-04)}

\item{verbose}{If TRUE (default), current progress is shown; if FALSE, no output is produced}

\item{method}{indicates whether to use 'hmm' (Hidden Markov Models), 'ols' (Ordinary Least Squares) 
to re-estimate the recombination fractions while merging the parental maps (default:hmm)}
}
\value{
list containing three \code{mappoly.map} objects:1) map built with markers with segregation information from parent 1; 
2) map built with markers with segregation information from parent 2; 3) maps in 1 and 2 merged
}
\description{
Design linkage map framework in two steps: i) estimating the recombination fraction with 
HMM approach for each parent separately using only markers segregating individually 
(e.g. map 1 - P1:3 x P2:0, P1: 2x4; map 2 - P1:0 x P2:3, P1:4 x P2:2); ii) merging both 
maps and re-estimate recombination fractions.
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu} with documentation and minor modifications by Cristiane Taniguti \email{chtaniguti@tamu.edu}
}
