% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_list_to_matrix.R
\name{rf_list_to_matrix}
\alias{rf_list_to_matrix}
\alias{print.mappoly.rf.matrix}
\alias{plot.mappoly.rf.matrix}
\title{Recombination fraction list to matrix}
\usage{
rf_list_to_matrix(
  input.twopt,
  thresh.LOD.ph = 0,
  thresh.LOD.rf = 0,
  thresh.rf = 0.5,
  ncpus = 1L,
  shared.alleles = FALSE,
  verbose = TRUE
)

\method{print}{mappoly.rf.matrix}(x, ...)

\method{plot}{mappoly.rf.matrix}(
  x,
  type = c("rf", "lod"),
  ord = NULL,
  rem = NULL,
  main.text = NULL,
  index = FALSE,
  fact = 1,
  ...
)
}
\arguments{
\item{input.twopt}{an object of class \code{poly.est.two.pts.pairwise}}

\item{thresh.LOD.ph}{LOD score threshold for linkage phase configurations (default = 0)}

\item{thresh.LOD.rf}{LOD score threshold for recombination fractions (default = 0)}

\item{thresh.rf}{the threshold used for recombination fraction filtering (default = 0.5)}

\item{ncpus}{number of parallel processes (i.e. cores) to spawn (default = 1)}

\item{shared.alleles}{if \code{TRUE}, computes two matrices (for both parents) indicating 
the number of homologues that share alleles (default = FALSE)}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if
\code{FALSE}, no output is produced}

\item{x}{an object of class \code{mappoly.rf.matrix}}

\item{...}{currently ignored}

\item{type}{type of matrix that should be printed. Can be one of the
following: \code{"rf"}, for recombination fraction or \code{"lod"}
for LOD Score}

\item{ord}{the order in which the markers should be plotted (default = NULL)}

\item{rem}{which markers should be removed from the heatmap (default = NULL)}

\item{main.text}{a character string as the title of the heatmap (default = NULL)}

\item{index}{\code{logical} should the name of the markers be printed in the 
diagonal of the heatmap? (default = FALSE)}

\item{fact}{positive integer. factor expressed as number of cells to be aggregated 
(default = 1, no aggregation)}
}
\value{
A list containing two matrices. The first one contains the
    filtered recombination fraction and the second one contains the
    information matrix
}
\description{
Transforms the recombination fraction list contained in an object
of class \code{poly.est.two.pts.pairwise} into a recombination
fraction matrix
}
\details{
\code{thresh_LOD_ph} should be set in order to only select
    recombination fractions that have LOD scores associated to the
    linkage phase configuration higher than \code{thresh_LOD_ph}
    when compared to the second most likely linkage phase configuration.
}
\examples{
    all.mrk<-make_seq_mappoly(hexafake, 1:20)
    red.mrk<-elim_redundant(all.mrk)
    unique.mrks<-make_seq_mappoly(red.mrk)
    all.pairs<-est_pairwise_rf(input.seq = unique.mrks,
                               ncpus = 1,
                               verbose=TRUE)

    ## Full recombination fraction matrix
    mat.full<-rf_list_to_matrix(input.twopt=all.pairs)
    plot(mat.full)
    plot(mat.full, type = "lod")
 
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
