% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterer_farm.R
\name{global_hierarchical_clusterer}
\alias{global_hierarchical_clusterer}
\title{Global Longevity Clusterer}
\usage{
global_hierarchical_clusterer(method, dists, cut_height = -1)
}
\arguments{
\item{method}{A string to pass to \link{hclust} to tell it what kind of clustering to do.}

\item{dists}{The global distance matrix on which to run clustering to determine a global cutting height.}

\item{cut_height}{The cutting height at which you want all dendrograms to be cut. If this is not specified then the clusterer will use a cut height 5\% above the merge point preceding the tallest branch in the global dendrogram.}
}
\value{
A function that inputs a list of distance matrices and returns a list containing one vector per matrix, whose element names are data point names and whose values are cluster labels (relative to each matrix).
}
\description{
Create a dude to perform hierarchical clustering in a global context using the \link{hclust} package.
}
\details{
This clusterer cuts all dendrograms it is given at a uniform cutting height, defaulting to a heuristic if necessary.
}
\examples{
data = data.frame(x = sapply(1:100, function(x) cos(x)), y = sapply(1:100, function(x) sin(x)))
projx = data$x
names(projx) = row.names(data)

dists = dist(data)

num_bins = 10
percent_overlap = 25

cover = create_width_balanced_cover(min(projx), max(projx), num_bins, percent_overlap)

create_1D_mapper_object(data, dists, projx, cover, global_hierarchical_clusterer("mcquitty", dists))
}
