% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_scatter_plot.R
\name{scatter_plot}
\alias{scatter_plot}
\title{PCA or DAPC Scatter Plot}
\usage{
scatter_plot(
  dataframe,
  group_ids,
  other_group = NULL,
  type = "points",
  ...,
  labels = NULL,
  axes = c(1, 2),
  colours = NULL,
  centroids = TRUE,
  segments = TRUE,
  point_size = 3,
  point_type = 21,
  centroid_size = 3,
  hvline_type = "dotted",
  hvline_size = 0.5,
  hvline_colour = "black",
  xlab = "Axis",
  ylab = "Axis",
  percent = NULL,
  plot_title = ""
)
}
\arguments{
\item{dataframe}{data.frame or tibble containing results from a PCA or DAPC (see examples).}

\item{group_ids}{character vector of IDs representing the group each row belongs to.
This is used to colour the scatter plot and (optionally) add centroids and segments.
E.g. a vector of site names, a vector of biological categories such as male or female, etc.}

\item{other_group}{secondary character vector of IDs defining how to colour the scatter plot.
E.g. a vector of country names (see examples).
If \code{NULL}, scatter plot is coloured by group_ids.}

\item{type}{string defining whether to show points (\code{"points"}), labels (\code{"labels"}), or text (\code{"text"}).}

\item{...}{additional arguments passed to \code{ggplot2::geom_point} when \code{type = "points"},
or to \code{ggplot2::geom_label} when \code{type = "labels"},
or to \code{ggplot2::geom_text} when \code{type = "text"}.}

\item{labels}{character vector of IDs defining labels when \code{type = "label"} or \code{type = "text"}.
If \code{NULL}, row names are used (integers from 1:nrow(dataframe)).}

\item{axes}{integer vector of length two defining which axes to plot.}

\item{colours}{character vector of colours the same length as the number of
groups defined in group_ids or other_group.}

\item{centroids}{add centroids to plot (\code{TRUE} or \code{FALSE}).}

\item{segments}{add segments to plot (\code{TRUE} or \code{FALSE}).}

\item{point_size}{numeric value for point size.}

\item{point_type}{numeric value for point type (shape).}

\item{centroid_size}{numeric value for centroid label size.}

\item{hvline_type}{integer or string defining linetype (\code{1} or \code{"dotted"}).
Input \code{0} for no horizontal and vertical lines.}

\item{hvline_size}{integer defining linewidth.}

\item{hvline_colour}{string defining line colour.}

\item{xlab}{string defining x axis label.}

\item{ylab}{string defining y axis label.}

\item{percent}{numeric vector the same length as \code{ncol(dataframe)} defining the
percentage of variance explained by each axis.}

\item{plot_title}{string defining the main title of the plot.}
}
\value{
A ggplot object.
}
\description{
Plot a scatter plot of PCA or DAPC results.
}
\examples{
# Results from a Principal Components Analysis
file <- system.file("extdata", "pca_results.csv", package = "mapmixture")
pca_results <- read.csv(file)

# Define parameters
ind_names <- row.names(pca_results)
site_names <- rep(c("Pop1", "Pop2", "Pop3", "Pop4", "Pop5", "Pop6"), each = 100)
region_names <- rep(c("Region1", "Region2"), each = 300)
percent <- c(5.6, 4.5, 3.2, 2.0, 0.52)

# Scatter plot
scatter_plot(pca_results, site_names)

# Scatter plot with axes 1 and 3 and percent on axis labels
scatter_plot(pca_results, site_names, axes = c(1,3), percent = percent)

# Scatter plot with no centroids and segments
scatter_plot(pca_results, site_names, axes = c(1,2), percent = percent,
             centroids = FALSE, segments = FALSE)

# Scatter plot with custom colours and coloured by other_group
scatter_plot(pca_results, site_names, other_group = region_names,
             percent = percent, colours = c("#f1a340","#998ec3"))

# Scatter plot with individual labels
scatter_plot(pca_results, site_names, type = "labels",
             labels = rownames(pca_results))

# Scatter plot with individual text
scatter_plot(pca_results, site_names, type = "text",
             labels = rownames(pca_results))
}
