% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_teow.R
\docType{data}
\name{teow}
\alias{teow}
\title{Calculate terrestrial ecoregions statistics (TEOW) based on WWF}
\format{
A tibble with a column for name of the ecoregions and corresponding area (in ha).
}
\description{
This function allows to efficiently retrieve the name of the ecoregions
and compute the corresponding area from Terrestrial Ecoregions of the
World (TEOW) - World Wildlife Fund (WWF) for polygons. For each polygon,
the name and area of the ecoregions (in hectare) is returned.
The required resources for this indicator are:
\itemize{
\item \link{ecoregions}
}
}
\examples{
library(sf)
library(mapme.biodiversity)
(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg", package = "mapme.biodiversity") \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2001,
    outdir = system.file("res", package = "mapme.biodiversity"),
    tmpdir = system.file("tmp", package = "mapme.biodiversity"),
    add_resources = FALSE,
    cores = 1,
    verbose = FALSE
  ) \%>\%
  get_resources("ecoregions") \%>\%
  calc_indicators("teow") \%>\%
  tidyr::unnest(teow))
}
\keyword{indicator}
