
# mapi

<!-- badges: start -->
<!-- badges: end -->

MAPI is an exploratory method providing graphical representations of the spatial variation of 
pairwise metrics (eg. distance, similarity coefficient, ...) computed between georeferenced samples.

## Installation

You can install the released version of mapi from [CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("mapi")
```

## Example

This basic example illustrates MAPI usage based on internal data.
This dataset have been generated by simulation. In real life, the crs 3857 is not accurate. Use a projection of coordinates in line with your sampling area.
For demonstration purposes 100 permutations are faster but unreliable. For a true dataset 1000 to 10,000 permutations should be OK.

``` r
library(mapi)
data("samples")
data(metric)
mapi.out <- MAPI_RunAuto(samples, metric, crs=3857, beta=0.5, nbPermuts=100)
mapi.tails <- MAPI_Tails(mapi.out, alpha=0.05)
MAPI_Plot2(mapi.out, mapi.tails, samples=samples)
```

